/*
   DESCRIPTION
     This demo shows how to configure validation to start with
     a root element or complex type

 */


import oracle.xml.parser.schema.*;
import oracle.xml.util.QxName;
import oracle.xml.parser.v2.*;

import java.net.*;
import java.io.*;
import org.w3c.dom.*;
import java.util.*;

public class xsdproperty
{
  public static void main(String[] args) throws Exception 
  {
      String xmlfile = args[0];
      String xsdfile =  args[1];
      System.out.println ("-- process file: " + xmlfile + "  "+ xsdfile);

      XSDBuilder builder = new XSDBuilder();
      URL    url =  XMLUtil.createURL(xsdfile);       
      XMLSchema  schema;
      String ns = args[2];
      String nm = args[3];
      String el = args[4];
      QxName qname = new QxName(ns, nm);
      try
      {
         XSDNode nd;
         schema = (XMLSchema) builder.build(url);
         if (el.equals("true"))
         {
            nd = schema.getElement(ns, nm);
            process1(xmlfile, schema, qname);
            process3(xmlfile, schema, nd);
         }
         else
         {
            nd = schema.getType(ns, nm, XSDNode.TYPE);
            process2(xmlfile, schema, qname);
            process3(xmlfile, schema, nd);
         }
      }
      catch (Exception e)
      {
        ;
      }
  }

  static void process1(String xmlURI, XMLSchema schema, QxName qname) 
      throws Exception 
  {
      try {
    DOMParser dp  = new DOMParser();
    URL       url = XMLUtil.createURL (xmlURI);

    dp.setXMLSchema(schema);
    dp.setSchemaValidatorProperty(XSDNode.ROOT_ELEMENT, qname);
    dp.setPreserveWhitespace (true);
    dp.setErrorStream (System.out);
    dp.parse (url);
      } catch (Exception e) {;}
  }

  static void process2(String xmlURI, XMLSchema schema, QxName qname) 
      throws Exception 
  {
      try {
    DOMParser dp  = new DOMParser();
    URL       url = XMLUtil.createURL (xmlURI);

    dp.setXMLSchema(schema);
    dp.setSchemaValidatorProperty(XSDNode.ROOT_TYPE, qname);
    dp.setPreserveWhitespace (true);
    dp.setErrorStream (System.out);
    dp.parse (url);
      } catch (Exception e) {;}
  }

  static void process3(String xmlURI, XMLSchema schema, XSDNode node) 
      throws Exception 
  {
      try {
    DOMParser dp  = new DOMParser();
    URL       url = XMLUtil.createURL (xmlURI);

    dp.setXMLSchema(schema);
    dp.setSchemaValidatorProperty(XSDNode.ROOT_NODE, node);
    dp.setPreserveWhitespace (true);
    dp.setErrorStream (System.out);
    dp.parse (url);
      } catch (Exception e) {;}
  }
}
